<?php
require_once("rebate_functions.php");

echo "<h2>VIP Rebate Rate Table</h2>";
echo "<style>
    table { border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
    th { background-color: #f2f2f2; }
    .highlight { background-color: #ffffcc; }
</style>";

echo "<table>";
echo "<tr><th>VIP Level</th><th>Rebate Rate</th><th>Percentage</th><th>Example: ₹100 Bet</th><th>Example: ₹1000 Bet</th></tr>";

for ($vipLevel = 0; $vipLevel <= 10; $vipLevel++) {
    $rate = getVipRebateRate($vipLevel);
    $percentage = $rate * 100;
    $example100 = $rate * 100;
    $example1000 = $rate * 1000;
    
    $rowClass = ($vipLevel == 0) ? 'style="background-color: #ffcccc;"' : 
                (($vipLevel == 1) ? 'class="highlight"' : '');
    
    echo "<tr $rowClass>";
    echo "<td>" . ($vipLevel == 0 ? "No VIP" : "VIP $vipLevel") . "</td>";
    echo "<td>$rate</td>";
    echo "<td>{$percentage}%</td>";
    echo "<td>₹" . number_format($example100, 2) . "</td>";
    echo "<td>₹" . number_format($example1000, 2) . "</td>";
    echo "</tr>";
}

echo "</table>";

echo "<h3>Key Points:</h3>";
echo "<ul>";
echo "<li><strong>No VIP (Level 0)</strong>: No rebate - users must unlock VIP Level 1 to get rebates</li>";
echo "<li><strong>VIP Level 1-2</strong>: 0.05% rebate rate</li>";
echo "<li><strong>VIP Level 3-5</strong>: 0.1% rebate rate</li>";
echo "<li><strong>VIP Level 6-8</strong>: 0.15% rebate rate</li>";
echo "<li><strong>VIP Level 9</strong>: 0.2% rebate rate</li>";
echo "<li><strong>VIP Level 10</strong>: 0.3% rebate rate (highest)</li>";
echo "</ul>";

echo "<h3>How it Works:</h3>";
echo "<ol>";
echo "<li>When a user places a bet, the system checks their VIP level</li>";
echo "<li>If VIP level is 0, no rebate is processed</li>";
echo "<li>If VIP level is 1 or higher, rebate is calculated based on their VIP level</li>";
echo "<li>Rebate is automatically added to the bet_rebates table</li>";
echo "<li>Users can view their rebate history and totals through the API</li>";
echo "</ol>";
?>
